/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.manager;

import filenet.vw.apps.manager.IVWFolderSelectionListener;
import filenet.vw.apps.manager.IVWItemSelectionListener;
import filenet.vw.apps.manager.IVWMilestonesSelectionListener;
import filenet.vw.apps.manager.IVWQueueSelectionListener;
import filenet.vw.apps.manager.IVWWorkflowManagerActionListener;
import filenet.vw.apps.manager.VWFolderSelectionEvent;
import filenet.vw.apps.manager.VWItemSelectionEvent;
import filenet.vw.apps.manager.VWMilestonesSelectionEvent;
import filenet.vw.apps.manager.VWQueueSelectionEvent;
import filenet.vw.apps.manager.VWWorkflowManagerActionEvent;
import filenet.vw.apps.manager.images.VWImageLoader;
import filenet.vw.apps.manager.resources.VWResource;
import filenet.vw.base.VWDebug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;
import javax.swing.event.EventListenerList;

public class VWWorkflowManagerToolBar
extends JToolBar
implements ActionListener,
IVWFolderSelectionListener,
IVWQueueSelectionListener,
IVWMilestonesSelectionListener,
IVWItemSelectionListener {
    private static final int NUMBER_OF_OPS = 6;
    private static final int OP_DEFINE_QUERY = 0;
    private static final int OP_REFRESH_ITEM_LIST = 1;
    private static final int OP_NEXT_SET = 2;
    private static final int OP_USER_PREFERENCES = 3;
    private static final int OP_DELETE_TRACKER_ITEM = 4;
    private static final int OP_DISPLAY_HELP = 5;
    private AbstractButton[] m_buttons = null;
    private EventListenerList m_actionListenerList = null;
    private boolean m_bTrackerQueueSelected = false;

    public VWWorkflowManagerToolBar() {
        try {
            this.m_actionListenerList = new EventListenerList();
            this.setFloatable(false);
            this.setBorderPainted(false);
            this.createButtons();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void enableNext(boolean enable) {
        this.enableButton(2, enable);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source.equals(this.m_buttons[0])) {
                this.fireActionEvent(new VWWorkflowManagerActionEvent(this, 2));
            } else if (source.equals(this.m_buttons[1])) {
                this.fireActionEvent(new VWWorkflowManagerActionEvent(this, 3));
            } else if (source.equals(this.m_buttons[2])) {
                this.fireActionEvent(new VWWorkflowManagerActionEvent(this, 7));
            } else if (source.equals(this.m_buttons[3])) {
                this.fireActionEvent(new VWWorkflowManagerActionEvent(this, 4));
            } else if (source.equals(this.m_buttons[4])) {
                this.fireActionEvent(new VWWorkflowManagerActionEvent(this, 6));
            } else if (source.equals(this.m_buttons[5])) {
                this.fireActionEvent(new VWWorkflowManagerActionEvent(this, 5));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void selectionChanged(VWFolderSelectionEvent event) {
        this.resetButtons();
    }

    public void selectionChanged(VWQueueSelectionEvent event) {
        this.resetButtons();
        this.enableButton(0, true);
        this.m_bTrackerQueueSelected = event.getNodeInformation().isTrackerQueue();
    }

    public void selectionChanged(VWMilestonesSelectionEvent event) {
        this.resetButtons();
        this.m_bTrackerQueueSelected = false;
    }

    public void selectionChanged(VWItemSelectionEvent event) {
        boolean bEnableTrackerButton = this.m_bTrackerQueueSelected && event.getType() == 1 && event.getRowIndex() != -1;
        this.enableButton(4, bEnableTrackerButton);
    }

    public void addWorkflowManagerActionListener(IVWWorkflowManagerActionListener listener) {
        this.m_actionListenerList.add(IVWWorkflowManagerActionListener.class, listener);
    }

    public void removeWorkflowManagerActionListener(IVWWorkflowManagerActionListener listener) {
        this.m_actionListenerList.remove(IVWWorkflowManagerActionListener.class, listener);
    }

    private void createButtons() {
        try {
            this.m_buttons = new AbstractButton[6];
            this.m_buttons[0] = this.createButton("query.gif", VWResource.s_defineQuery, false);
            if (this.m_buttons[0] != null) {
                this.add(this.m_buttons[0]);
                this.m_buttons[0].setRolloverEnabled(false);
            }
            this.m_buttons[1] = this.createButton("refresh.gif", VWResource.s_refreshItemList, true);
            if (this.m_buttons[1] != null) {
                this.add(this.m_buttons[1]);
                this.m_buttons[1].setRolloverEnabled(true);
            }
            this.m_buttons[2] = this.createButton("next.gif", VWResource.s_nextSet, false);
            if (this.m_buttons[2] != null) {
                this.add(this.m_buttons[2]);
                this.m_buttons[2].setRolloverEnabled(false);
            }
            this.addSeparator();
            this.m_buttons[3] = this.createButton("userinfo.gif", VWResource.s_userPreferences, true);
            if (this.m_buttons[3] != null) {
                this.add(this.m_buttons[3]);
                this.m_buttons[3].setRolloverEnabled(true);
            }
            this.addSeparator();
            this.m_buttons[4] = this.createButton("delwork.gif", VWResource.s_deleteTrackerItem, false);
            if (this.m_buttons[4] != null) {
                this.add(this.m_buttons[4]);
                this.m_buttons[4].setRolloverEnabled(false);
            }
            this.addSeparator();
            this.m_buttons[5] = this.createButton("help.gif", VWResource.s_displayHelp, true);
            if (this.m_buttons[5] != null) {
                this.add(this.m_buttons[5]);
                this.m_buttons[5].setRolloverEnabled(true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private AbstractButton createButton(String iconName, String name, boolean bEnable) {
        try {
            AbstractButton button = VWImageLoader.createToolBarButton(iconName, name, false);
            if (button != null) {
                button.setEnabled(bEnable);
                button.addActionListener(this);
                return button;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void resetButtons() {
        this.enableButton(0, false);
        this.enableButton(1, true);
        this.enableButton(2, false);
        this.enableButton(4, false);
    }

    private void enableButton(int nButtonIndex, boolean bEnable) {
        if (this.m_buttons != null && nButtonIndex >= 0 && nButtonIndex < this.m_buttons.length) {
            this.m_buttons[nButtonIndex].setEnabled(bEnable);
            this.m_buttons[nButtonIndex].setRolloverEnabled(bEnable);
        }
    }

    private void fireActionEvent(VWWorkflowManagerActionEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_actionListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWWorkflowManagerActionListener.class) continue;
            ((IVWWorkflowManagerActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }
}

